/**
 * @file
 * JavaScript behaviors for details element.
 */

(function ($, Drupal) {

  'use strict';

  /**
   * Attach handler to details with invalid inputs.
   *
   * @type {Drupal~behavior}
   */
  Drupal.behaviors.webformDetailsInvalid = {
    attach: function (context) {
      $('details :input', context).on('invalid', function () {
        $(this).parents('details:not([open])').children('summary').trigger('click');

        // Synd details toggle label.
        if (Drupal.webform && Drupal.webform.detailsToggle) {
          Drupal.webform.detailsToggle.setDetailsToggleLabel($(this.form));
        }
      });
    }
  };

})(jQuery, Drupal);
