!function (e, n) { "object" == typeof exports && "object" == typeof module ? module.exports = n() : "function" == typeof define && define.amd ? define([], n) : "object" == typeof exports ? exports.CKEditor5 = n() : (e.CKEditor5 = e.CKEditor5 || {}, e.CKEditor5.accordion = n()) }(self, (() => (() => { var __webpack_modules__ = { "./js/ckeditor5_plugins/accordion/src/accordion.js": (__unused_webpack_module, __webpack_exports__, __webpack_require__) => { "use strict"; eval('__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "default": () => (/* binding */ Accordion)\n/* harmony export */ });\n/* harmony import */ var _accordionediting__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./accordionediting */ "./js/ckeditor5_plugins/accordion/src/accordionediting.js");\n/* harmony import */ var _accordionui__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./accordionui */ "./js/ckeditor5_plugins/accordion/src/accordionui.js");\n/* harmony import */ var _accordiontoolbar__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./accordiontoolbar */ "./js/ckeditor5_plugins/accordion/src/accordiontoolbar.js");\n/* harmony import */ var ckeditor5_src_core__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ckeditor5/src/core */ "ckeditor5/src/core.js");\n/**\n * @file This is what CKEditor refers to as a master (glue) plugin. Its role is\n * just to load the “editing” and “UI” components of this Plugin. Those\n * components could be included in this file, but\n *\n * I.e, this file\'s purpose is to integrate all the separate parts of the plugin\n * before it\'s made discoverable via index.js.\n */\n// cSpell:ignore accordionediting accordion\n\n// The contents of AccordionUI and AccordionEditing could be included in this\n// file, but it is recommended to separate these concerns in different files.\n\n\n\n\n\nclass Accordion extends ckeditor5_src_core__WEBPACK_IMPORTED_MODULE_3__.Plugin {\n  static get requires() {\n    return [_accordionediting__WEBPACK_IMPORTED_MODULE_0__["default"], _accordionui__WEBPACK_IMPORTED_MODULE_1__["default"], _accordiontoolbar__WEBPACK_IMPORTED_MODULE_2__["default"]];\n  }\n}\n\n\n//# sourceURL=webpack://CKEditor5.accordion/./js/ckeditor5_plugins/accordion/src/accordion.js?') }, "./js/ckeditor5_plugins/accordion/src/accordionediting.js": (__unused_webpack_module, __webpack_exports__, __webpack_require__) => { "use strict"; eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"default\": () => (/* binding */ AccordionEditing)\n/* harmony export */ });\n/* harmony import */ var ckeditor5_src_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ckeditor5/src/core */ \"ckeditor5/src/core.js\");\n/* harmony import */ var ckeditor5_src_widget__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ckeditor5/src/widget */ \"ckeditor5/src/widget.js\");\n/* harmony import */ var _insertaccordioncommand__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./insertaccordioncommand */ \"./js/ckeditor5_plugins/accordion/src/insertaccordioncommand.js\");\n/* harmony import */ var _insertaccordionrowcommand__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./insertaccordionrowcommand */ \"./js/ckeditor5_plugins/accordion/src/insertaccordionrowcommand.js\");\n/* harmony import */ var _deleteaccordionrowcommand__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./deleteaccordionrowcommand */ \"./js/ckeditor5_plugins/accordion/src/deleteaccordionrowcommand.js\");\n\n\n\n\n\n\n\n// cSpell:ignore accordion insertsimpleboxcommand\n\n/**\n * CKEditor 5 plugins do not work directly with the DOM. They are defined as\n * plugin-specific data models that are then converted to markup that\n * is inserted in the DOM.\n *\n * CKEditor 5 internally interacts with accordion as this model:\n * <accordion>\n *    <accordionTitle></accordionTitle>\n *    <accordionContent></accordionContent>\n * </accordion>\n *\n * Which is converted for the browser/user as this markup\n * <section class=\"simple-box\">\n *   <h2 class=\"simple-box-title\"></h1>\n *   <div class=\"simple-box-description\"></div>\n * </section>\n *\n * This file has the logic for defining the accordion model, and for how it is\n * converted to standard DOM markup.\n */\nclass AccordionEditing extends ckeditor5_src_core__WEBPACK_IMPORTED_MODULE_0__.Plugin {\n  /**\n   * @inheritDoc\n   */\n  static get pluginName() {\n    return 'AccordionEditing';\n  }\n\n  static get requires() {\n    return [ckeditor5_src_widget__WEBPACK_IMPORTED_MODULE_1__.Widget];\n  }\n\n  init() {\n    this._defineSchema();\n    this._defineConverters();\n    this.editor.commands.add(\n      'insertAccordion',\n      new _insertaccordioncommand__WEBPACK_IMPORTED_MODULE_2__[\"default\"](this.editor),\n    );\n\n    this.editor.commands.add(\n      'insertAccordionRowAbove',\n      new _insertaccordionrowcommand__WEBPACK_IMPORTED_MODULE_3__[\"default\"](this.editor, { order: 'above' })\n    );\n    this.editor.commands.add(\n      'insertAccordionRowBelow',\n      new _insertaccordionrowcommand__WEBPACK_IMPORTED_MODULE_3__[\"default\"]( this.editor, { order: 'below' } )\n    );\n    this.editor.commands.add(\n      'deleteAccordionRow',\n      new _deleteaccordionrowcommand__WEBPACK_IMPORTED_MODULE_4__[\"default\"]( this.editor, {} )\n    );\n\n  }\n\n  /*\n   * This registers the structure that will be seen by CKEditor 5 as\n   * <accordion>\n   *    <accordionTitle></accordionTitle>\n   *    <accordionContent></accordionContent>\n   * </accordion>\n   *\n   * The logic in _defineConverters() will determine how this is converted to\n   * markup.\n   */\n  _defineSchema() {\n    // Schemas are registered via the central `editor` object.\n    const schema = this.editor.model.schema;\n\n    schema.register('accordion', {\n      // Behaves like a self-contained object (e.g. an image).\n      isObject: true,\n      // Allow in places where other blocks are allowed (e.g. directly in the root).\n      allowWhere: '$block',\n    });\n\n    schema.register( 'accordionRow', {\n      allowIn: 'accordion',\n      isLimit: true\n    } );\n\n    schema.register('accordionTitle', {\n      // This creates a boundary for external actions such as clicking and\n      // and keypress. For example, when the cursor is inside this box, the\n      // keyboard shortcut for \"select all\" will be limited to the contents of\n      // the box.\n      isLimit: true,\n      // This is only to be used within accordion.\n      allowIn: 'accordion',\n      // Allow content that is allowed in blocks (e.g. text with attributes).\n      allowContentOf: '$block',\n    });\n\n    schema.register('accordionContent', {\n      isLimit: true,\n      allowIn: 'accordion',\n      allowContentOf: '$root',\n    });\n\n    schema.addChildCheck((context, childDefinition) => {\n      // Disallow accordion inside accordionContent.\n      if (\n        context.endsWith('accordionContent') &&\n        childDefinition.name === 'accordion'\n      ) {\n        return false;\n      }\n    });\n  }\n\n  /**\n   * Converters determine how CKEditor 5 models are converted into markup and\n   * vice-versa.\n   */\n  _defineConverters() {\n    // Converters are registered via the central editor object.\n    const { conversion } = this.editor;\n\n    // Upcast Converters: determine how existing HTML is interpreted by the\n    // editor. These trigger when an editor instance loads.\n    //\n    // If <dl class=\"ckeditor-accordion\"> is present in the existing markup\n    // processed by CKEditor, then CKEditor recognizes and loads it as a\n    // <accordion> model.\n    conversion.for('upcast').elementToElement({\n      model: 'accordion',\n      view: {\n        name: 'dl',\n        classes: 'ckeditor-accordion',\n      },\n    });\n\n    // If <dt> is present in the existing markup\n    // processed by CKEditor, then CKEditor recognizes and loads it as a\n    // <accordionTitle> model, provided it is a child element of <accordion>,\n    // as required by the schema.\n    conversion.for('upcast').elementToElement({\n      model: 'accordionTitle',\n      view: {\n        name: 'dt',\n        classes: '',\n      },\n    });\n\n    // If <dd> is present in the existing markup\n    // processed by CKEditor, then CKEditor recognizes and loads it as a\n    // <accordionContent> model, provided it is a child element of\n    // <accordion>, as required by the schema.\n    conversion.for('upcast').elementToElement({\n      model: 'accordionContent',\n      view: {\n        name: 'dd',\n        classes: '',\n      },\n    });\n\n    // Data Downcast Converters: converts stored model data into HTML.\n    // These trigger when content is saved.\n    //\n    // Instances of <accordion> are saved as\n    // <dl class=\"ckeditor-accordion\">{{inner content}}</dl>.\n    conversion.for('dataDowncast').elementToElement({\n      model: 'accordion',\n      view: {\n        name: 'dl',\n        classes: 'ckeditor-accordion',\n      },\n    });\n\n    // Instances of <accordionTitle> are saved as\n    // <dt>{{inner content}}</dt>.\n    conversion.for('dataDowncast').elementToElement({\n      model: 'accordionTitle',\n      view: {\n        name: 'dt',\n        classes: '',\n      },\n    });\n\n    // Instances of <accordionContent> are saved as\n    // <dd>{{inner content}}</dd>.\n    conversion.for('dataDowncast').elementToElement({\n      model: 'accordionContent',\n      view: {\n        name: 'dd',\n        classes: '',\n      },\n    });\n\n    // Editing Downcast Converters. These render the content to the user for\n    // editing, i.e. this determines what gets seen in the editor. These trigger\n    // after the Data Upcast Converters, and are re-triggered any time there\n    // are changes to any of the models' properties.\n    //\n    // Convert the <accordion> model into a container widget in the editor UI.\n    conversion.for('editingDowncast').elementToElement({\n      model: 'accordion',\n      view: (modelElement, { writer: viewWriter }) => {\n        const div = viewWriter.createContainerElement('div', {\n          class: 'ckeditor-accordion',\n        });\n\n        return (0,ckeditor5_src_widget__WEBPACK_IMPORTED_MODULE_1__.toWidget)(div, viewWriter);\n      },\n    });\n\n    // Convert the <accordionTitle> model into an editable <h2> widget.\n    conversion.for('editingDowncast').elementToElement({\n      model: 'accordionTitle',\n      view: (modelElement, { writer: viewWriter }) => {\n        const h2 = viewWriter.createEditableElement('div', {\n          class: 'ckeditor-accordion-title',\n        });\n        return (0,ckeditor5_src_widget__WEBPACK_IMPORTED_MODULE_1__.toWidgetEditable)(h2, viewWriter);\n      },\n    });\n\n    // Convert the <accordionContent> model into an editable <div> widget.\n    conversion.for('editingDowncast').elementToElement({\n      model: 'accordionContent',\n      view: (modelElement, { writer: viewWriter }) => {\n        const div = viewWriter.createEditableElement('div', {\n          class: 'ckeditor-accordion-content',\n        });\n        return (0,ckeditor5_src_widget__WEBPACK_IMPORTED_MODULE_1__.toWidgetEditable)(div, viewWriter);\n      },\n    });\n  }\n}\n\n\n//# sourceURL=webpack://CKEditor5.accordion/./js/ckeditor5_plugins/accordion/src/accordionediting.js?") }, "./js/ckeditor5_plugins/accordion/src/accordiontoolbar.js": (__unused_webpack_module, __webpack_exports__, __webpack_require__) => { "use strict"; eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"default\": () => (/* binding */ AccordionToolbar)\n/* harmony export */ });\n/* harmony import */ var ckeditor5_src_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ckeditor5/src/core */ \"ckeditor5/src/core.js\");\n/* harmony import */ var ckeditor5_src_widget__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ckeditor5/src/widget */ \"ckeditor5/src/widget.js\");\n/* harmony import */ var _utils_ui_widget__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./utils/ui/widget */ \"./js/ckeditor5_plugins/accordion/src/utils/ui/widget.js\");\n/**\n * @license Copyright (c) 2003-2022, CKSource Holding sp. z o.o. All rights reserved.\n * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license\n */\n\n/**\n * @module accordion/accordiontoolbar\n */\n\n\n\n\n\n/**\n * The accordion toolbar class. It creates toolbars for the accordion feature and its content (for now only for the accordion cell content).\n *\n * @extends module:core/plugin~Plugin\n */\nclass AccordionToolbar extends ckeditor5_src_core__WEBPACK_IMPORTED_MODULE_0__.Plugin {\n  /**\n   * @inheritDoc\n   */\n  static get requires() {\n    return [ ckeditor5_src_widget__WEBPACK_IMPORTED_MODULE_1__.WidgetToolbarRepository ];\n  }\n\n  /**\n   * @inheritDoc\n   */\n  static get pluginName() {\n    return 'AccordionToolbar';\n  }\n\n  /**\n   * @inheritDoc\n   */\n  afterInit() {\n    const editor = this.editor;\n    const t = editor.t;\n    const widgetToolbarRepository = editor.plugins.get( ckeditor5_src_widget__WEBPACK_IMPORTED_MODULE_1__.WidgetToolbarRepository );\n\n    const accordionContentToolbarItems = editor.config.get( 'accordion.contentToolbar' );\n\n    const accordionToolbarItems = editor.config.get( 'accordion.tableToolbar' );\n\n    if ( accordionContentToolbarItems ) {\n      widgetToolbarRepository.register( 'accordionContent', {\n        ariaLabel: t( 'Accordion toolbar' ),\n        items: accordionContentToolbarItems,\n        getRelatedElement: _utils_ui_widget__WEBPACK_IMPORTED_MODULE_2__.getAccordionWidgetAncestor\n      } );\n    }\n\n    if ( accordionToolbarItems ) {\n      widgetToolbarRepository.register( 'accordion', {\n        ariaLabel: t( 'Accordion toolbar' ),\n        items: accordionToolbarItems,\n        getRelatedElement: _utils_ui_widget__WEBPACK_IMPORTED_MODULE_2__.getSelectedAccordionWidget\n      } );\n    }\n  }\n}\n\n\n//# sourceURL=webpack://CKEditor5.accordion/./js/ckeditor5_plugins/accordion/src/accordiontoolbar.js?") }, "./js/ckeditor5_plugins/accordion/src/accordionui.js": (__unused_webpack_module, __webpack_exports__, __webpack_require__) => { "use strict"; eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"default\": () => (/* binding */ AccordionUI)\n/* harmony export */ });\n/* harmony import */ var ckeditor5_src_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ckeditor5/src/core */ \"ckeditor5/src/core.js\");\n/* harmony import */ var ckeditor5_src_ui__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ckeditor5/src/ui */ \"ckeditor5/src/ui.js\");\n/* harmony import */ var _icons_ckeditor_accordion_svg__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../../icons/ckeditor-accordion.svg */ \"./icons/ckeditor-accordion.svg\");\n/* harmony import */ var _icons_ckeditor_accordion_add_above_svg__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../../icons/ckeditor-accordion-add-above.svg */ \"./icons/ckeditor-accordion-add-above.svg\");\n/* harmony import */ var _icons_ckeditor_accordion_add_below_svg__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../../../icons/ckeditor-accordion-add-below.svg */ \"./icons/ckeditor-accordion-add-below.svg\");\n/* harmony import */ var _icons_ckeditor_accordion_remove_svg__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../../../icons/ckeditor-accordion-remove.svg */ \"./icons/ckeditor-accordion-remove.svg\");\n/**\n * @file registers the accordion toolbar button and binds functionality to it.\n */\n\n\n\n\n\n\n\n\nclass AccordionUI extends ckeditor5_src_core__WEBPACK_IMPORTED_MODULE_0__.Plugin {\n  /**\n   * @inheritdoc\n   */\n  static get requires() {\n    return [ckeditor5_src_ui__WEBPACK_IMPORTED_MODULE_1__.ContextualBalloon];\n  }\n\n  init() {\n    const editor = this.editor;\n    const t = this.editor.t;\n\n    // This will register the accordion toolbar button.\n    editor.ui.componentFactory.add('accordion', (locale) => {\n      const command = editor.commands.get('insertAccordion');\n      const buttonView = new ckeditor5_src_ui__WEBPACK_IMPORTED_MODULE_1__.ButtonView(locale);\n\n      // Create the toolbar button.\n      buttonView.set({\n        label: t('Accordion'),\n        icon: _icons_ckeditor_accordion_svg__WEBPACK_IMPORTED_MODULE_2__[\"default\"],\n        tooltip: true,\n      });\n\n      // Bind the state of the button to the command.\n      buttonView.bind('isOn', 'isEnabled').to(command, 'value', 'isEnabled');\n\n      // Execute the command when the button is clicked (executed).\n      this.listenTo(buttonView, 'execute', () =>\n        editor.execute('insertAccordion'),\n      );\n\n      return buttonView;\n    });\n\n    editor.ui.componentFactory.add( 'accordionAddAbove', (locale) => {\n      const command = editor.commands.get('insertAccordionRowAbove');\n      const buttonView = new ckeditor5_src_ui__WEBPACK_IMPORTED_MODULE_1__.ButtonView(locale);\n\n      // Create the toolbar button.\n      buttonView.set({\n        label: t('Insert row above'),\n        iconAddAbove: _icons_ckeditor_accordion_add_above_svg__WEBPACK_IMPORTED_MODULE_3__[\"default\"],\n        tooltip: false,\n        withText: true,\n      });\n\n      // Bind the state of the button to the command.\n      buttonView.bind('isOn', 'isEnabled').to(command, 'value', 'isEnabled');\n\n      // Execute the command when the button is clicked (executed).\n      this.listenTo(buttonView, 'execute', () =>\n        editor.execute( 'insertAccordionRowAbove' ),\n      );\n\n      return buttonView;\n    } );\n\n    editor.ui.componentFactory.add( 'accordionAddBelow', (locale) => {\n      const command = editor.commands.get('insertAccordionRowBelow');\n      const buttonView = new ckeditor5_src_ui__WEBPACK_IMPORTED_MODULE_1__.ButtonView(locale);\n\n      // Create the toolbar button.\n      buttonView.set({\n        label: t('Insert row below'),\n        iconAddBelow: _icons_ckeditor_accordion_add_below_svg__WEBPACK_IMPORTED_MODULE_4__[\"default\"],\n        tooltip: false,\n        withText: true,\n      });\n\n      // Bind the state of the button to the command.\n      buttonView.bind('isOn', 'isEnabled').to(command, 'value', 'isEnabled');\n\n      // Execute the command when the button is clicked (executed).\n      this.listenTo(buttonView, 'execute', () =>\n        editor.execute( 'insertAccordionRowBelow' ),\n      );\n\n      return buttonView;\n    } );\n\n    editor.ui.componentFactory.add( 'accordionRemove', (locale) => {\n      const command = editor.commands.get('deleteAccordionRow');\n      const buttonView = new ckeditor5_src_ui__WEBPACK_IMPORTED_MODULE_1__.ButtonView(locale);\n\n      // Create the toolbar button.\n      buttonView.set({\n        label: t('Delete row'),\n        iconDelete: _icons_ckeditor_accordion_remove_svg__WEBPACK_IMPORTED_MODULE_5__[\"default\"],\n        tooltip: false,\n        withText: true,\n      });\n\n      // Bind the state of the button to the command.\n      buttonView.bind('isOn', 'isEnabled').to(command, 'value', 'isEnabled');\n\n      // Execute the command when the button is clicked (executed).\n      this.listenTo(buttonView, 'execute', () =>\n        editor.execute('deleteAccordionRow'),\n      );\n\n      return buttonView;\n    } );\n\n  }\n\n}\n\n\n//# sourceURL=webpack://CKEditor5.accordion/./js/ckeditor5_plugins/accordion/src/accordionui.js?") }, "./js/ckeditor5_plugins/accordion/src/deleteaccordionrowcommand.js": (__unused_webpack_module, __webpack_exports__, __webpack_require__) => { "use strict"; eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"default\": () => (/* binding */ DeleteAccordionRowCommand)\n/* harmony export */ });\n/* harmony import */ var ckeditor5_src_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ckeditor5/src/core */ \"ckeditor5/src/core.js\");\n/**\n * @file defines DeleteAccordionRowCommand.\n */\n// cSpell:ignore accordionediting\n\n\n\n/**\n * The delete accordion row command.\n *\n * @extends module:core/command~Command\n */\nclass DeleteAccordionRowCommand extends ckeditor5_src_core__WEBPACK_IMPORTED_MODULE_0__.Command {\n  /**\n   * Creates a new `DeleteAccordionRowCommand` instance.\n   *\n   * @param {module:core/editor/editor~Editor} editor The editor on which this command will be used.\n   * @param {Object} options\n   */\n  constructor( editor, options = {} ) {\n    super( editor );\n  }\n\n  execute() {\n    const editor = this.editor;\n    const selection = editor.model.document.selection;\n    let elToDelete = null;\n\n    selection.getFirstPosition().getAncestors().forEach(ancestor => {\n      if(ancestor.name == 'accordionContent' || ancestor.name == 'accordionTitle') {\n        elToDelete = ancestor;\n      }\n    });\n\n    if(elToDelete != null) {\n      // Command is being run from a correct context.\n      editor.model.change((writer) => {\n        let siblingElToDelete, siblingIndex;\n        if(elToDelete.name == 'accordionContent') {\n          // Sibling is accordionTitle.\n          siblingIndex = elToDelete.index - 1;\n        }\n        else {\n          // Sibling is accordionContent.\n          siblingIndex = elToDelete.index + 1;\n        }\n        siblingElToDelete = elToDelete.parent.getChild(siblingIndex);\n\n        // Remove elements.\n        writer.remove(elToDelete);\n        writer.remove(siblingElToDelete);\n      });\n    }\n  }\n\n  refresh() {\n    this.isEnabled = true;\n  }\n\n}\n\n\n//# sourceURL=webpack://CKEditor5.accordion/./js/ckeditor5_plugins/accordion/src/deleteaccordionrowcommand.js?") }, "./js/ckeditor5_plugins/accordion/src/index.js": (__unused_webpack_module, __webpack_exports__, __webpack_require__) => { "use strict"; eval('__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)\n/* harmony export */ });\n/* harmony import */ var _accordion__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./accordion */ "./js/ckeditor5_plugins/accordion/src/accordion.js");\n/**\n * @module ckeditor_accordion\n */\n\n\n\n/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({\n  Accordion: _accordion__WEBPACK_IMPORTED_MODULE_0__["default"]\n});\n\n\n//# sourceURL=webpack://CKEditor5.accordion/./js/ckeditor5_plugins/accordion/src/index.js?') }, "./js/ckeditor5_plugins/accordion/src/insertaccordioncommand.js": (__unused_webpack_module, __webpack_exports__, __webpack_require__) => { "use strict"; eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"default\": () => (/* binding */ InsertAccordionCommand)\n/* harmony export */ });\n/* harmony import */ var ckeditor5_src_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ckeditor5/src/core */ \"ckeditor5/src/core.js\");\n/**\n * @file defines InsertAccordionCommand, which is executed when the accordion\n * toolbar button is pressed.\n */\n// cSpell:ignore accordionediting\n\n\n\nclass InsertAccordionCommand extends ckeditor5_src_core__WEBPACK_IMPORTED_MODULE_0__.Command {\n  execute() {\n    const { model } = this.editor;\n\n    model.change((writer) => {\n      // Insert <accordion>*</accordion> at the current selection position\n      // in a way that will result in creating a valid model structure.\n      model.insertContent(createAccordion(writer));\n    });\n  }\n\n  refresh() {\n    const { model } = this.editor;\n    const { selection } = model.document;\n\n    // Determine if the cursor (selection) is in a position where adding a\n    // accordion is permitted. This is based on the schema of the model(s)\n    // currently containing the cursor.\n    const allowedIn = model.schema.findAllowedParent(\n      selection.getFirstPosition(),\n      'accordion',\n    );\n\n    // If the cursor is not in a location where a accordion can be added, return\n    // null so the addition doesn't happen.\n    this.isEnabled = allowedIn !== null;\n  }\n}\n\nfunction createAccordion(writer) {\n  // Create an accordion.\n  const accordion = writer.createElement('accordion');\n  const accordionTitle = writer.createElement('accordionTitle');\n  const accordionContent = writer.createElement('accordionContent');\n\n  writer.append(accordionTitle, accordion);\n  writer.append(accordionContent, accordion);\n\n  writer.appendElement('paragraph', accordionContent);\n\n  // Return the element to be added to the editor.\n  return accordion;\n}\n\n\n//# sourceURL=webpack://CKEditor5.accordion/./js/ckeditor5_plugins/accordion/src/insertaccordioncommand.js?") }, "./js/ckeditor5_plugins/accordion/src/insertaccordionrowcommand.js": (__unused_webpack_module, __webpack_exports__, __webpack_require__) => { "use strict"; eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"default\": () => (/* binding */ InsertAccordionRowCommand)\n/* harmony export */ });\n/* harmony import */ var ckeditor5_src_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ckeditor5/src/core */ \"ckeditor5/src/core.js\");\n/**\n * @file defines InsertAccordionRowCommand.\n */\n// cSpell:ignore accordionediting\n\n\n\n/**\n * The insert accordion row command.\n *\n * @extends module:core/command~Command\n */\nclass InsertAccordionRowCommand extends ckeditor5_src_core__WEBPACK_IMPORTED_MODULE_0__.Command {\n  /**\n   * Creates a new `InsertAccordionRowCommand` instance.\n   *\n   * @param {module:core/editor/editor~Editor} editor The editor on which this command will be used.\n   * @param {Object} options\n   * @param {String} [options.order=\"below\"] The order of insertion relative to the row in which the caret is located.\n   * Possible values: `\"above\"` and `\"below\"`.\n   */\n  constructor( editor, options = {} ) {\n    super( editor );\n\n    /**\n     * The order of insertion relative to the row in which the caret is located.\n     *\n     * @readonly\n     * @member {String} module:accordion/commands/insertaccordionrowcommand~InsertAccordionRowCommand#order\n     */\n    this.order = options.order || 'below';\n  }\n\n  execute() {\n    const editor = this.editor;\n    const selection = editor.model.document.selection;\n    let commandEl = null;\n\n    selection.getFirstPosition().getAncestors().forEach(ancestor => {\n      if(ancestor.name == 'accordionContent' || ancestor.name == 'accordionTitle') {\n        commandEl = ancestor;\n      }\n    });\n\n    if(commandEl != null) {\n      // Command is being run from a correct context.\n      editor.model.change((writer) => {\n        let position;\n        if(this.order == 'below') {\n          let insertAfterIndex = (commandEl.name == 'accordionContent') ? commandEl.index : commandEl.index + 1;\n          if(insertAfterIndex < 0) {\n            insertAfterIndex = 0;\n          }\n          // Add row below this row's accordionTitle.\n          position = writer.createPositionAfter(commandEl.parent.getChild(insertAfterIndex));\n        }\n        else {\n          let insertBeforeIndex = (commandEl.name == 'accordionContent') ? commandEl.index - 1 : commandEl.index;\n\n          if(insertBeforeIndex < 0) {\n            insertBeforeIndex = 0;\n          }\n          // Add row above this row's accordionTitle.\n          position = writer.createPositionBefore(commandEl.parent.getChild(insertBeforeIndex));\n        }\n\n        // Create the accordion title and content and add em.\n        const accordionTitle = writer.createElement('accordionTitle');\n        const accordionContent = writer.createElement('accordionContent');\n\n        // Create some default title.\n        writer.insertText('Accordion title', accordionTitle);\n\n        // Do the insert.\n        writer.insert(accordionContent, position);\n        writer.insert(accordionTitle, position);\n\n        // Create some default content.\n        const accordionContentParagraph = writer.createElement('paragraph');\n        writer.appendText('Accordion content.', accordionContentParagraph);\n        writer.insert(accordionContentParagraph, accordionContent);\n\n        // Select the inserted title row.\n        // TODO.\n      });\n    }\n  }\n\n  refresh() {\n    this.isEnabled = true;\n  }\n\n}\n\n\n//# sourceURL=webpack://CKEditor5.accordion/./js/ckeditor5_plugins/accordion/src/insertaccordionrowcommand.js?") }, "./js/ckeditor5_plugins/accordion/src/utils/ui/widget.js": (__unused_webpack_module, __webpack_exports__, __webpack_require__) => { "use strict"; eval('__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "getAccordionWidgetAncestor": () => (/* binding */ getAccordionWidgetAncestor),\n/* harmony export */   "getSelectedAccordionWidget": () => (/* binding */ getSelectedAccordionWidget)\n/* harmony export */ });\n/* harmony import */ var ckeditor5_src_widget__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ckeditor5/src/widget */ "ckeditor5/src/widget.js");\n/**\n * @license Copyright (c) 2003-2022, CKSource Holding sp. z o.o. All rights reserved.\n * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license\n */\n\n/**\n * @module ckeditor_accordion/utils/ui/widget\n */\n\n\n\n/**\n * Returns a ckeditor_accordion widget editing view element if one is selected.\n *\n * @param {module:engine/view/selection~Selection|module:engine/view/documentselection~DocumentSelection} selection\n * @returns {module:engine/view/element~Element|null}\n */\nfunction getSelectedAccordionWidget( selection ) {\n  const viewElement = selection.getSelectedElement();\n\n  if ( viewElement && isAccordionWidget( viewElement ) ) {\n    return viewElement;\n  }\n\n  return null;\n}\n\n/**\n * Returns a ckeditor_accordion widget editing view element if one is among the selection\'s ancestors.\n *\n * @param {module:engine/view/selection~Selection|module:engine/view/documentselection~DocumentSelection} selection\n * @returns {module:engine/view/element~Element|null}\n */\nfunction getAccordionWidgetAncestor( selection ) {\n  const selectionPosition = selection.getFirstPosition();\n\n  if ( !selectionPosition ) {\n    return null;\n  }\n\n  let parent = selectionPosition.parent;\n  while ( parent ) {\n    if ( parent.is( \'element\' ) && isAccordionWidget( parent ) ) {\n\n      return parent;\n    }\n\n    parent = parent.parent;\n  }\n\n  return null;\n}\n\n// Checks if a given view element is a ckeditor_accordion widget.\n//\n// @param {module:engine/view/element~Element} viewElement\n// @returns {Boolean}\nfunction isAccordionWidget( viewElement ) {\n  return !!viewElement.hasClass( \'ckeditor-accordion\' ) && (0,ckeditor5_src_widget__WEBPACK_IMPORTED_MODULE_0__.isWidget)( viewElement );\n}\n\n\n//# sourceURL=webpack://CKEditor5.accordion/./js/ckeditor5_plugins/accordion/src/utils/ui/widget.js?') }, "./icons/ckeditor-accordion-add-above.svg": (__unused_webpack_module, __webpack_exports__, __webpack_require__) => { "use strict"; eval('__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)\n/* harmony export */ });\n/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ("<?xml version=\\"1.0\\" encoding=\\"utf-8\\"?>\\n<!DOCTYPE svg PUBLIC \\"-//W3C//DTD SVG 1.1//EN\\" \\"http://www.w3.org/Graphics/SVG/1.1/DTD/svg11.dtd\\">\\n<svg width=\\"76px\\" height=\\"76px\\" viewBox=\\"0 0 76 76\\" xmlns=\\"http://www.w3.org/2000/svg\\" xmlns:xlink=\\"http://www.w3.org/1999/xlink\\" version=\\"1.1\\" baseProfile=\\"full\\" enable-background=\\"new 0 0 76.00 76.00\\" xml:space=\\"preserve\\">\\n\\t<path fill=\\"currentColor\\" fill-opacity=\\"1\\" stroke-width=\\"0.2\\" stroke-linejoin=\\"round\\" d=\\"M 14,27L 46,27L 46,38L 40,38L 40,54L 14,54L 14,27 Z M 43,35L 43,30L 17,30L 17,35L 43,35 Z M 37,38L 17,38L 17,43L 37,43L 37,38 Z M 37,46L 17,46L 17,51L 37,51L 37,46 Z M 50,30L 55,30L 55,25L 60,25L 60,30L 65,30L 65,35L 60,35L 60,40L 55,40L 55,35L 50,35L 50,30 Z \\"/>\\n</svg>\\n");\n\n//# sourceURL=webpack://CKEditor5.accordion/./icons/ckeditor-accordion-add-above.svg?') }, "./icons/ckeditor-accordion-add-below.svg": (__unused_webpack_module, __webpack_exports__, __webpack_require__) => { "use strict"; eval('__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)\n/* harmony export */ });\n/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ("<?xml version=\\"1.0\\" encoding=\\"utf-8\\"?>\\n<!DOCTYPE svg PUBLIC \\"-//W3C//DTD SVG 1.1//EN\\" \\"http://www.w3.org/Graphics/SVG/1.1/DTD/svg11.dtd\\">\\n<svg width=\\"76px\\" height=\\"76px\\" viewBox=\\"0 0 76 76\\" xmlns=\\"http://www.w3.org/2000/svg\\" xmlns:xlink=\\"http://www.w3.org/1999/xlink\\" version=\\"1.1\\" baseProfile=\\"full\\" enable-background=\\"new 0 0 76.00 76.00\\" xml:space=\\"preserve\\">\\n\\t<path fill=\\"currentColor\\" fill-opacity=\\"1\\" stroke-width=\\"0.2\\" stroke-linejoin=\\"round\\" d=\\"M 50,48L 50,43L 55,43L 55,38L 60,38L 60,43L 65,43L 65,48L 60,48L 60,53L 55,53L 55,48L 50,48 Z M 14,51L 14,24L 40,24L 40,40L 46,40L 46,51L 14,51 Z M 43,43L 17,43L 17,48L 43,48L 43,43 Z M 37,40L 37,35L 17,35L 17,40L 37,40 Z M 37,32L 37,27L 17,27L 17,32L 37,32 Z \\"/>\\n</svg>\\n");\n\n//# sourceURL=webpack://CKEditor5.accordion/./icons/ckeditor-accordion-add-below.svg?') }, "./icons/ckeditor-accordion-remove.svg": (__unused_webpack_module, __webpack_exports__, __webpack_require__) => { "use strict"; eval('__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)\n/* harmony export */ });\n/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ("<?xml version=\\"1.0\\" encoding=\\"utf-8\\"?>\\n<!DOCTYPE svg PUBLIC \\"-//W3C//DTD SVG 1.1//EN\\" \\"http://www.w3.org/Graphics/SVG/1.1/DTD/svg11.dtd\\">\\n<svg width=\\"24px\\" height=\\"24px\\" viewBox=\\"0 0 24 24\\" fill=\\"none\\" xmlns=\\"http://www.w3.org/2000/svg\\">\\n    <path d=\\"M5 3H3v18h18V3H5zm14 2v14H5V5h14zm-3 6H8v2h8v-2z\\" fill=\\"currentColor\\"/>\\n</svg>\\n");\n\n//# sourceURL=webpack://CKEditor5.accordion/./icons/ckeditor-accordion-remove.svg?') }, "./icons/ckeditor-accordion.svg": (__unused_webpack_module, __webpack_exports__, __webpack_require__) => { "use strict"; eval('__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)\n/* harmony export */ });\n/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ("<?xml version=\\"1.0\\" encoding=\\"UTF-8\\"?>\\r\\n<!DOCTYPE svg PUBLIC \\"-//W3C//DTD SVG 1.1//EN\\" \\"http://www.w3.org/Graphics/SVG/1.1/DTD/svg11.dtd\\">\\r\\n<svg width=\\"17px\\" height=\\"17px\\" viewBox=\\"0 0 17 17\\" version=\\"1.1\\" xmlns=\\"http://www.w3.org/2000/svg\\" xmlns:xlink=\\"http://www.w3.org/1999/xlink\\">\\r\\n<g>\\r\\n</g>\\r\\n\\t<path d=\\"M0 0v17h17v-17h-17zM16 1v9h-15v-9h15zM16 11v2h-15v-2h15zM1 16v-2h15v2h-15z\\" fill=\\"currentColor\\"/>\\r\\n</svg>");\n\n//# sourceURL=webpack://CKEditor5.accordion/./icons/ckeditor-accordion.svg?') }, "ckeditor5/src/core.js": (module, __unused_webpack_exports, __webpack_require__) => { eval('module.exports = (__webpack_require__(/*! dll-reference CKEditor5.dll */ "dll-reference CKEditor5.dll"))("./src/core.js");\n\n//# sourceURL=webpack://CKEditor5.accordion/delegated_./core.js_from_dll-reference_CKEditor5.dll?') }, "ckeditor5/src/ui.js": (module, __unused_webpack_exports, __webpack_require__) => { eval('module.exports = (__webpack_require__(/*! dll-reference CKEditor5.dll */ "dll-reference CKEditor5.dll"))("./src/ui.js");\n\n//# sourceURL=webpack://CKEditor5.accordion/delegated_./ui.js_from_dll-reference_CKEditor5.dll?') }, "ckeditor5/src/widget.js": (module, __unused_webpack_exports, __webpack_require__) => { eval('module.exports = (__webpack_require__(/*! dll-reference CKEditor5.dll */ "dll-reference CKEditor5.dll"))("./src/widget.js");\n\n//# sourceURL=webpack://CKEditor5.accordion/delegated_./widget.js_from_dll-reference_CKEditor5.dll?') }, "dll-reference CKEditor5.dll": e => { "use strict"; e.exports = CKEditor5.dll } }, __webpack_module_cache__ = {}; function __webpack_require__(e) { var n = __webpack_module_cache__[e]; if (void 0 !== n) return n.exports; var o = __webpack_module_cache__[e] = { exports: {} }; return __webpack_modules__[e](o, o.exports, __webpack_require__), o.exports } __webpack_require__.d = (e, n) => { for (var o in n) __webpack_require__.o(n, o) && !__webpack_require__.o(e, o) && Object.defineProperty(e, o, { enumerable: !0, get: n[o] }) }, __webpack_require__.o = (e, n) => Object.prototype.hasOwnProperty.call(e, n), __webpack_require__.r = e => { "undefined" != typeof Symbol && Symbol.toStringTag && Object.defineProperty(e, Symbol.toStringTag, { value: "Module" }), Object.defineProperty(e, "__esModule", { value: !0 }) }; var __webpack_exports__ = __webpack_require__("./js/ckeditor5_plugins/accordion/src/index.js"); return __webpack_exports__ = __webpack_exports__.default, __webpack_exports__ })()));
