/**
 * @file
 * Loads the FlexSlider library.
 */

(function ($) {

  'use strict';

  Drupal.behaviors.flexslider = {
    attach: function (context, settings) {
      var sliders = [];
      var id;
      if ($.type(settings.flexslider) !== 'undefined' && $.type(settings.flexslider.instances) !== 'undefined') {

        for (id in settings.flexslider.instances) {

          if (settings.flexslider.instances.hasOwnProperty(id)) {
            if ($.type(settings.flexslider.optionsets) !== 'undefined' && settings.flexslider.instances[id] in settings.flexslider.optionsets) {
              if (settings.flexslider.optionsets[settings.flexslider.instances[id]].asNavFor !== '') {
                // We have to initialize all the sliders which are "asNavFor" first.
                _flexslider_init(id, settings.flexslider.optionsets[settings.flexslider.instances[id]], context);
              }
              else {
                // Everyone else is second.
                sliders[id] = settings.flexslider.optionsets[settings.flexslider.instances[id]];
              }
            }
          }
        }
      }
      // Slider set.
      for (id in sliders) {
        if (sliders.hasOwnProperty(id)) {
          _flexslider_init(id, settings.flexslider.optionsets[settings.flexslider.instances[id]], context);
        }
      }
    }
  };

  /**
   * Initialize the flexslider instance.
   *
   * @param {string} id
   * Id selector of the flexslider object.
   * @param {object} optionset
   * The optionset to apply to the flexslider object.
   * @param {object} context
   * The DOM context.
     * @private
     */
  function _flexslider_init(id, optionset, context) {
    $('#' + id, context).once('flexslider').each(function () {
      // Remove width/height attributes.
      // @todo load the css path from the settings
      $(this).find('ul.slides > li > *').removeAttr('width').removeAttr('height');

      if (optionset) {
        // Add events that developers can use to interact.
        $(this).flexslider($.extend(optionset, {
          start: function (slider) {
            slider.trigger('start', [slider]);
          },
          before: function (slider) {
            slider.trigger('before', [slider]);
          },
          after: function (slider) {
            slider.trigger('after', [slider]);
          },
          end: function (slider) {
            slider.trigger('end', [slider]);
          },
          added: function (slider) {
            slider.trigger('added', [slider]);
          },
          removed: function (slider) {
            slider.trigger('removed', [slider]);
          },
          init: function (slider) {
            slider.trigger('init', [slider]);
          }
        }));
      }
      else {
        $(this).flexslider();
      }
    });
  }

}(jQuery));
